/*======================================================================
*** structs.h ***
* (c) Alma L. Juarez-Dominguez, Richard Fanson
* Declaration of generic node structure and function prototypes.
*
* Created: August 2007
* Last modified: September 9, 2008
*======================================================================*/

#ifndef STRUCT_H
#define STRUCT_H


/*****************************************************************************************
***************************     STRUCTURE DECLARATIONS     *******************************
*****************************************************************************************/

/******************************************************
Node Structure
******************************************************/

// generic node with fields to account for all types (unneeded fields will be left as 0 or NULL)
typedef struct node_t {

	
	int id;	// stores id for STATE, TRANS, JUNC, EVENT, DATA

	// stores string for the labels and names of STATE, TRANS, JUNC, EVENT, DATA
	char* labelString;

	// id's that come from the treeNode and listNode entries in .mdl
	int parentId;		
	int childId;		
	int leftSibId;		
	int rightSibId;		

	// from the firstTransition entry in STATES 
	int firstTrans;	

	// type of STATE
	char* type;	

	// execution 
	int execOrder;		// for STATE, TRANS

	int src;		// for TRANS
	int dst;		// for TRANS

	// from the scope entry of EVENTS and DATA
	char* scope;

	// from the trigger entry for EVENTS, and dataType for DATA
	char* triggerData;

	// for linked list structure
	struct node_t *next;
	
	// for tree structure
	struct node_t *parent;
	struct node_t *child;
	struct node_t *leftSib;
	struct node_t *rightSib;
	
	int min_range;		// for DATA, minimum range in values
	int max_range;		// for DATA, maximum range in values
	int init_val;		// for LOCAL DATA, initial value
	
} node;

/******************************************************
List Structure
******************************************************/
typedef struct list_t {
	int count;
	enum {NONE, STATE_L, JUNC_L, TRANS_L, EVENT_L, DATA_L, STATE_T} type;
	node * head;
} list;


/*****************************************************************************************
***************************     FUNCTIONS PROTOTYPES     *********************************
*****************************************************************************************/

/******************************************************
functions found in functions.c
******************************************************/
node * createNode();
list * createList(int listType);
int deleteNode(node * toDelete);
int deleteList(list * listDel);
int printNode(node * toPrint);
int printList(list * toPrint);


int addToList(list * addList, node * addNode);
int makeTree();
int transLink();

int addId(node* node, int id);
int addLabelString(list* list, char* label);
int concatLabelString(list* list, char* addLabel);
int addRelations(node* node, int parent, int child, int leftSib, int rightSib);
int addFirstTrans(list* list, int trans);
int addType(list* list, char* type);
int addExecOrder(list* list, int order);
int addSrcId(list* list, int srcId);
int addDstId(list* list, int dstId);
int addName(list* list, char* name);
int addScope(list* list, char* scope);
int addTriggerData(list* list, char* triggerData);
int addMinMax(list* list, char* min, char* max);
int addInitVal(list* list, char* val_init);

int moveStateActions();
int moveActions(node* state);

void removeQuotes(char* string);
void removeLabelQuotes(node* node);
int FindNum(char* string);
node * findEnd(list * listGiven);
void sanityCheck();
int checkAND();

/******************************************************
functions found in printing.c
******************************************************/
void printInputOutput();
void printEvents();
void printTrans(int trans_hierarchy);
void printStates();
void printInits(int trans_hierarchy);
void printStable(node* parent);
void printInnerstatesToDefault (node* state, node* transparent);
void printOuterstatesToCurrent (node* temp, int *ANDupdating, int *ANDleveldone);
void printORstateToDefault(node* state);
void printANDstateToNextSib (node* state, int *ANDupdating, int *ANDleveldone);
void printSwitch(node* state, int trans_hierarchy);
void printSMV(int trans_hierarchy);

int transEvent(node* trans, char* event);
int transCond(node* trans, char* cond);
int transAction(node* trans, char* action);
int transCondAction(node* trans, char* action);

void align();
void alignStr(char* string);
int mkEventCond(char* name, char* event);
int addStored(char* condition);
void storeInputs(node* child);








#endif
