/*======================================================================
*** mdlparser.y ***
* (c) Alma L. Juarez-Dominguez, Richard Fanson
* Grammar definitions given the structure of the .mdl file.
* Compile as: % yacc -d mdlparser.y
*
* Created: August 2007
* Last modified: August 1, 2010
*======================================================================*/

%{

#include "data.h"
#include "structs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern list* stateList;
extern list* transList;
extern list* juncList;
extern list* eventList;
extern list* dataList;
extern list* stateTree;

%}

%union {string s; int n; }

%token STATEFLOW 
%token CHART STATE JUNCTION TRANSITION EVENT DATA 
%token ID LABELSTRING TREENODE LINKNODE FIRSTTRANS TYPE TYPE2 EXECORDER SOURCE DESTINATION NAME SCOPE TRIGGER 
%token PROPS RANGE ARRAY MIN_RANGE MAX_RANGE INIT_VAL DATATYPE 
%token <s> STATE_TYPE
%token <s> JUNCTION_TYPE
%token <s> DATAOREVENT
%token <n> NUMBER 
%token <s> STRING

%%

features:
	| features feature
	;

feature:
	STATEFLOW chart_ent state_list junc_list trans_list event_list data_list {
		#ifdef DEBUG
		fprintf(stderr,"\n---------------StateFlow done!---------------\n\n");
		#endif
	}
	;

chart_ent:
	CHART chart_dtls {
		#ifdef DEBUG
		fprintf(stderr,"---------------Chart Entry done!---------------\n\n");
		#endif
	}
	;

chart_dtls:
	chart_attr
	| chart_dtls chart_attr
	;

chart_attr:
	ID NUMBER { 
		#ifdef DEBUG
		fprintf(stderr,"Id: %d\n", $2); 
		#endif
		
		node * new = createNode();	
		addToList(stateList, new);
		addId(new, $2);	
		
	}
	| NAME STRING {
		#ifdef DEBUG
		fprintf(stderr,"Label: %s\n", $2);
		#endif

		addLabelString(stateList, $2); /* why do i get "warning:  incompatible implicit declaration of 							built-in function ‘strdup’" here ... got rid of warning by adding 								string.h library  */

	}
	| TREENODE NUMBER NUMBER NUMBER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"TreeNode: %d %d %d %d\n",$2,$3,$4,$5);
		#endif
		
		node* end = findEnd(stateList);
		addRelations(end, $2, $3, $4, $5);
	}
	| FIRSTTRANS NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"FirstTransition: %d\n", $2);
		#endif

		addFirstTrans(stateList, $2);
	}
	| EXECORDER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"Exec Order: %d\n", $2);
		#endif
		
		addExecOrder(stateList, $2);
	}
	;


state_list: /* how can i account for no entry without getting shift/reduce conflict? */
	| state_ent
	| state_list state_ent
	;

state_ent:
	STATE state_dtls { 
		#ifdef DEBUG
		fprintf(stderr,"---------------State Entry done!---------------\n\n");
		#endif

		//printNode(findEnd(stateList));	//uncomment this line to print a node every time its created
	}
	;

state_dtls: 
	state_attr
	| state_dtls state_attr
	;

state_attr:
	ID NUMBER { 
		#ifdef DEBUG
		fprintf(stderr,"Id: %d\n", $2); 
		#endif
		
		node * new = createNode();	
		addToList(stateList, new);
		addId(new, $2);	
		
	}
	| LABELSTRING STRING {
		#ifdef DEBUG
		fprintf(stderr,"Label: %s\n", $2);
		#endif

		addLabelString(stateList, $2); /* why do i get "warning:  incompatible implicit declaration of 							built-in function ‘strdup’" here ... got rid of warning by adding 								string.h library  */

	}
	| STRING {
		#ifdef DEBUG
		fprintf(stderr,"More Label: %s\n", $1);
		#endif
		
		concatLabelString(stateList, $1);
		
	}
	| TREENODE NUMBER NUMBER NUMBER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"TreeNode: %d %d %d %d\n",$2,$3,$4,$5);
		#endif
		
		node* end = findEnd(stateList);
		addRelations(end, $2, $3, $4, $5);
	}
	| FIRSTTRANS NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"FirstTransition: %d\n", $2);
		#endif

		addFirstTrans(stateList, $2);
	}
	| TYPE STATE_TYPE {
		#ifdef DEBUG
		fprintf(stderr,"Type: %s\n",$2);
		#endif

		addType(stateList, $2);
	}
	| EXECORDER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"Exec Order: %d\n", $2);
		#endif
		
		addExecOrder(stateList, $2);
	}
	;

junc_list: /* how can i account for no entry without getting shift/reduce conflict? */
	| junc_ent
	| junc_list junc_ent
	;

junc_ent:
	JUNCTION junc_dtls {
		#ifdef DEBUG
		fprintf(stderr,"---------------Junc Entry done!---------------\n\n");
		#endif
	}
	;

junc_dtls:
	junc_attr
	| junc_dtls junc_attr
	;

junc_attr:
	ID NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"Id: %d\n", $2);
		#endif

		node * new = createNode();	
		addToList(juncList, new);
		addId(new, $2);
	}
	| LABELSTRING STRING {
		#ifdef DEBUG
		fprintf(stderr,"Label: %s\n", $2);
		#endif

		addLabelString(juncList, $2); /* why do i get "warning:  incompatible implicit declaration of 							built-in function ‘strdup’" here ... got rid of warning by adding 								string.h library  */
	}
	| TYPE JUNCTION_TYPE {
		#ifdef DEBUG
		fprintf(stderr,"Type: %s\n", $2);
		#endif
	
		addType(juncList, $2);

	}
	| LINKNODE NUMBER NUMBER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"LinkNode: %d %d %d %d\n",$2,$3,$4);
		#endif

	/* will need to use this later to determine parent state of junction (esp for history)*/
	    node* end = findEnd(juncList);
		addRelations(end, $2, 0, $3, $4);
	}
	;

trans_list: /* how can i account for no entry without getting shift/reduce conflict? */
	| trans_ent
	| trans_list trans_ent
	;

trans_ent:
	TRANSITION trans_dtls {
		#ifdef DEBUG
		fprintf(stderr,"---------------Trans Entry done!---------------\n\n");
		#endif
	}
	;

trans_dtls:
	trans_attr
	| trans_dtls trans_attr
	;

trans_attr:
	ID NUMBER { 
		#ifdef DEBUG
		fprintf(stderr,"Id: %d\n", $2); 
		#endif

		node * new = createNode();	
		addToList(transList, new);
		addId(new, $2);	

	}
	| LABELSTRING STRING {
		#ifdef DEBUG
		fprintf(stderr,"Label: %s\n", $2);
		#endif

		addLabelString(transList, $2);
	}
	| STRING {
		#ifdef DEBUG
		fprintf(stderr,"More Label: %s\n", $1);
		#endif

		concatLabelString(transList, $1);
	}
	| SOURCE ID NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"Source: %d\n", $3);
		#endif

		addSrcId(transList, $3);
	}
	| SOURCE { /* Note that this is where the other shift/reduce comes from (its to catch default trans which has no src) */
		#ifdef DEBUG
		fprintf(stderr,"Source: default\n");
		#endif

		addSrcId(transList, 0); // this is a default trans, making source id 0
	}
	| DESTINATION ID NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"Destination: %d\n", $3);
		#endif

		addDstId(transList, $3);
	}
	| EXECORDER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"Exec Order: %d\n", $2);
		#endif

		addExecOrder(transList, $2);
	}
	| LINKNODE NUMBER NUMBER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"LinkNode:  %d %d %d\n",$2,$3,$4);
		#endif

		/* currently not used but may come in handy later */
	}
	;

event_list: /* how can i account for no entry without getting shift/reduce conflict? */
	| event_ent
	| event_list event_ent
	;

event_ent:
	EVENT event_dtls {
		#ifdef DEBUG
		fprintf(stderr,"-----------Event Entry done!----------\n\n");
		#endif
	}
	;

event_dtls:
	event_attr
	| event_dtls event_attr
	;

event_attr:
	ID NUMBER { 
		#ifdef DEBUG
		fprintf(stderr,"Id: %d\n", $2); 
		#endif

		node * new = createNode();	
		addToList(eventList, new);
		addId(new, $2);	
	}
	| NAME STRING {
		#ifdef DEBUG
		fprintf(stderr,"Name: %s\n", $2);
		#endif

		addLabelString(eventList, $2);
	}
	| SCOPE DATAOREVENT{
		#ifdef DEBUG
		fprintf(stderr,"Scope: %s\n", $2);
		#endif

		addScope(eventList, $2);
	}
	| TRIGGER DATAOREVENT {
		#ifdef DEBUG
		fprintf(stderr,"Trigger: %s\n", $2);
		#endif

		addTriggerData(eventList, $2);
	}
	| LINKNODE NUMBER NUMBER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"LinkNode:  %d %d %d\n",$2,$3,$4);
		#endif

		/* currently not used but may come in handy later */
	}
	;

data_list: /* how can i account for no entry without getting shift/reduce conflict? */
	| data_ent
	| data_list data_ent
	;

data_ent:
	DATA data_dtls {
		#ifdef DEBUG
		fprintf(stderr,"---------------Data Entry done!---------------\n\n");
		#endif
	}
	;

data_dtls:
	data_attr
	| data_dtls data_attr
	;

data_attr:
	ID NUMBER { 
		#ifdef DEBUG
		fprintf(stderr,"Id: %d\n", $2); 
		#endif

		node * new = createNode();	
		addToList(dataList, new);
		addId(new, $2);	
	}
	| NAME STRING {
		#ifdef DEBUG
		fprintf(stderr,"Name: %s\n", $2);
		#endif

		addLabelString(dataList, $2);
	}
	| SCOPE DATAOREVENT {
		#ifdef DEBUG
		fprintf(stderr,"Scope: %s\n", $2);
		#endif

		addScope(dataList, $2);
	}
	| DATATYPE STRING {
		#ifdef DEBUG
		fprintf(stderr,"DataType: %s\n", $2);
		#endif

		addTriggerData(dataList, $2);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING ARRAY TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, , Init_val: 0", $4, $6);
		#endif
		
		char buffer[2];
		buffer[0] = '0';
		buffer[1] = '\0';
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, buffer);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING INIT_VAL STRING ARRAY TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: %s", $4, $6, $8);
		#endif
		
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, $8);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING ARRAY INIT_VAL STRING TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: %s", $4, $6, $9);
		#endif
		
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, $9);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING ARRAY {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: 0", $4, $6);
		#endif
		
		char buffer[2];
		buffer[0] = '0';
		buffer[1] = '\0';
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, buffer);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING INIT_VAL STRING ARRAY {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: %s", $4, $6, $8);
		#endif
		
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, $8);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING ARRAY INIT_VAL STRING {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: %s", $4, $6, $9);
		#endif
		
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, $9);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: 0", $4, $6);
		#endif
		
		char buffer[2];
		buffer[0] = '0';
		buffer[1] = '\0';
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, buffer);
	}
	| PROPS RANGE MIN_RANGE STRING MAX_RANGE STRING INIT_VAL STRING TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Range_min: %s, Range_max: %s, Init_val: %s", $4, $6, $8);
		#endif
		
		addMinMax(dataList, $4, $6);
		addInitVal(dataList, $8);
	}
	| PROPS ARRAY TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Nothing");
		#endif
		
		/* It does nothing, just avoids parsing error */
	}
	| PROPS INIT_VAL STRING ARRAY TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Init_val: %s", $3);
		#endif
		
		addInitVal(dataList, $3);
	}
	| PROPS ARRAY INIT_VAL STRING TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Init_val: %s", $4);
		#endif
		
		addInitVal(dataList, $4);
	}
	| PROPS TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Nothing");
		#endif
		
		/* It does nothing, just avoids parsing error */
	}
	| PROPS INIT_VAL STRING TYPE2 {
		#ifdef DEBUG
		fprintf(stderr,"Init_val: %s", $3);
		#endif
		
		addInitVal(dataList, $3);
	}
	| PROPS ARRAY {
		#ifdef DEBUG
		fprintf(stderr,"Nothing");
		#endif
		
		/* It does nothing, just avoids parsing error */
	}
	| PROPS INIT_VAL STRING ARRAY {
		#ifdef DEBUG
		fprintf(stderr,"Init_val: %s", $3);
		#endif
		
		addInitVal(dataList, $3);
	}
	| PROPS ARRAY INIT_VAL STRING {
		#ifdef DEBUG
		fprintf(stderr,"Init_val: %s", $4);
		#endif
		
		addInitVal(dataList, $4);
	}
	| LINKNODE NUMBER NUMBER NUMBER {
		#ifdef DEBUG
		fprintf(stderr,"LinkNode:  %d %d %d\n",$2,$3,$4);
		#endif

		/* currently not used but may come in handy later */
	}
	;

%%
