/*======================================================================
*** mdlparser.l ***
* (c) Alma L. Juarez-Dominguez, Richard Fanson
* Token definitions for the elements that we want to capture 
*  from the .mdl file.
* Compile as: % lex mdlparser.l
*
* Created: August 2007
* Last modified: August 1, 2010
*======================================================================*/

%{

#include "data.h"
#include "structs.h"
#include <stdio.h>
#include <string.h>
#include "y.tab.h"

int linenum = 1;

/*
Note1: [\40-\176] matches all printable characters in the ASCII character set, from octal 40 (blank space) to octal 176 (tilde) but skipping octal 42 (quotation marks).
Note2: Need to add [\r\t\n]* to the end of the String macro definition ( ie make it: String [\"][\40-\176]+[\"][\r\t\n]* ) and add a + to the String token ( ie make it: {String}+ ) in order to parse the sf_cruise_control.mdl feature for some reason
Note3: Changed the string token to \"[^"]* so it looks for a quotation mark and then all characters that aren't quotation marks until the second quotation mark. So the above comments are now obsolete.
*/


%}


%%


"Model {"		{ /* useless simulink stuff before we get to Stateflow */
				#ifdef DEBUG
				fprintf(stderr,"\nNot Stateflow yet ... stripping insides ...\n");
				#endif
				int braces = 1, c = input();
				while(braces != 0)
				{
					if (c == '{') braces++;
					else if (c == '}') braces--;
					else if (c == '\n') linenum++;
					c = input();
				}
			}

#			{ /* comment line ... ignore */
				int c = input();
				while (c != '\n') {c = input();}
				linenum++;
			}

"machine {"		{
				#ifdef DEBUG
				fprintf(stderr,"machine found ... stripping insides ...\n");
				#endif
				int braces = 1, c = input();
				while(braces != 0)
				{
					if (c == '{') braces++;
					else if (c == '}') braces--;
					else if (c == '\n') linenum++;
					c = input();
				}
			}

"instance {"		{
				#ifdef DEBUG
				fprintf(stderr,"instance found ... stripping insides ...\n");
				#endif
				int braces = 1, c = input();
				while(braces != 0)
				{
					if (c == '{') braces++;
					else if (c == '}') braces--;
					else if (c == '\n') linenum++;
					c = input();
				}
			}

"target {"		{
				#ifdef DEBUG
				fprintf(stderr,"target found ... stripping insides ...\n");
				#endif
				int braces = 1, c = input();
				while(braces != 0)
				{
					if (c == '{') braces++;
					else if (c == '}') braces--;
					else if (c == '\n') linenum++;
					c = input();
				}
			}

[\n\r]				linenum++;	/* needed \r or output file has a bunch of space in it */
Stateflow			return STATEFLOW;
"chart {"			return CHART;
state				return STATE;
junction			return JUNCTION;
transition			return TRANSITION;
event				return EVENT;
data				return DATA;
id				return ID;
labelString			return LABELSTRING;
treeNode			return TREENODE;
linkNode			return LINKNODE;
firstTransition			return FIRSTTRANS;
"type {"			return TYPE2; /* ignore this 'type' */
type				return TYPE;
executionOrder			return EXECORDER;
src				return SOURCE;
dst				return DESTINATION;
name				return NAME;
scope				return SCOPE;
trigger				return TRIGGER;
props				return PROPS; /* fprintf(stderr, "props found\n"); */
range				return RANGE; /* fprintf(stderr, "range found\n"); */
array				return ARRAY; /* Do nothing, just to avoid parsing error */
minimum				return MIN_RANGE;
maximum				return MAX_RANGE;
initialValue		return INIT_VAL;
dataType			return DATATYPE;
[A-Z_]*_STATE			yylval.s = yytext; return STATE_TYPE;
[A-Z_]*_(DATA|EVENT)		yylval.s = yytext; return DATAOREVENT;
[A-Z_]*_JUNCTION		yylval.s = yytext; return JUNCTION_TYPE;
[0-9]+				yylval.n = atoi(yytext); return NUMBER;
\"[^"]*				yytext[yyleng++] = input(); yytext[yyleng++] = '\0'; yylval.s = yytext; return STRING;
[ \t]				/*ignore spaces*/				
\{				/*ignore brackets for now */
\}				/*ignore brackets for now */
\[				/*ignore brackets for now */
\]				/*ignore brackets for now */
[a-zA-Z][a-zA-Z0-9_]*		{/* cleanup unwanted */ int c = input(); while (c != '\n') c = input();}


%%
