/*======================================================================
*** main.c ***
* (c) Alma L. Juarez-Dominguez, Richard Fanson
* Function calls for parsing and to SMV creation functions.
*
* Created: August 2007
* Last modified: February 22, 2008
*======================================================================*/

#include "structs.h"
#include "data.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern FILE* yyin;
extern FILE* yyout;
extern int yyparse(void);
extern int linenum;

FILE* tree;
FILE* lists;
FILE* nodes;
FILE* DoneReady;

list* stateList = NULL;
list* transList = NULL;
list* juncList = NULL;
list* eventList = NULL;
list* dataList = NULL; 
list* stateTree = NULL;

int tabs = 0; // global variable used to help keep the indentation of the output
int tabsMAX = 0; // global variable used to know out maximum indentation ... no longer used
int ANDstates = 0; // global boolean flag to check if we have AND states since it changes our output significantly
int ANDlevel = 0; // global variable that holds the AND-state hierarchy level where the ordered composition is currently being updated
int Readyprinted = 0; // global boolean flag to check if the ready condition is already printed or not
int ReadyOR = 0; // global boolean flag that indicates that the ready condition is printed for OR-states (needs to be printed only once!)

void yyerror(const char *str)
{
	fprintf(stderr,"\n**********************************************************************\nError: %s at line %d of input file\nNote: You may need to manually remove the newlines from the labels in mdl file\nIf this is the case the line number mentioned above may be slighlty off the actually line where the error occurred\n**********************************************************************\n\n",str,linenum);
	exit(1);
}

int yywrap()
{
	return 1;
}

int main(int argc, char** argv)
{
    
    if (argc <= 1) { // The first arg will be the executable name
        // print usage
        fprintf(stderr, "mdl2smv input: input_file_name.mdl [-t (optional)] \n");
    }
    else
    {    
        yyin = fopen(argv[1],"r");

        if (yyin == NULL)
        {
            fprintf(stderr, "\nError! Could not open file!\n");
            exit(1);
        }
        
        tree = fopen("tree.txt", "w");
        if (tree == NULL)
        {
            fprintf(stderr, "\nError! Could not open Tree file!\n");
            exit(1);
        }

        lists = fopen("lists.txt", "w");
        if (lists == NULL)
        {
            fprintf(stderr, "\nError! Could not open Lists file!\n");
            exit(1);
        }
        nodes = fopen("nodes.txt", "w");
        if (nodes == NULL)
        {
            fprintf(stderr, "\nError! Could not open Nodes file!\n");
            exit(1);
        }

        stateList = createList(STATE_L);
        transList = createList(TRANS_L);
        juncList = createList(JUNC_L);
        eventList = createList(EVENT_L);
        dataList = createList(DATA_L);
        stateTree = createList(STATE_T); // NB: this tree will have the same nodes as stateList but in different formation

        yyparse();
        sanityCheck();

        makeTree();

        transLink();

    //	moveStateActions();

        #ifdef PRINTLIST
        printList(stateList);
        printList(juncList);
        printList(transList);
        printList(eventList);
        printList(dataList);
        #endif

        ANDstates=0;
        ANDstates = checkAND();

        if (argc>=3)
        {    
            if (!strcmp(argv[2], "-t")) // defines variables to print trans history
                printSMV(1);
            else
                printSMV(0);
        }
        else
             printSMV(0);
            
        deleteList(stateList);
        deleteList(juncList);
        deleteList(transList);
        deleteList(eventList);
        deleteList(dataList);
        deleteList(stateTree); // make sure to delete the stateList first to delete all the nodes properly, then the tree

        fprintf(stderr, "\n***** Parsing complete. See output file for SMV text *****\n\n");

        fclose(yyin);
        fclose(tree);
        fclose(lists);
	}
	return(1);
}
